/**
 *
 * Block .blockTags for BiomesOPlenty
 * ============================
 *
 *
 * This script assigns default .blockTags to BiomesOPlenty blocks.
 * The default stylesheet uses these .blockTags to determine block styles.
 *
 *
 * https://www.curseforge.com/minecraft/mc-mods/biomes-o-plenty
 *
 *
 */


class StyleSheet {

    build(builder) {
        builder.blockTag("#leaves").isFor("biomesoplenty:petals");


        builder.blockTag("#flower, #white").isFor("biomesoplenty:clover");
        builder.blockTag("#flower, #yellow").isFor("biomesoplenty:goldenrod, biomesoplenty:glowflower");
        builder.blockTag("#flower, #pink").isFor("biomesoplenty:pink_daffodil, biomesoplenty:pink_hibiscus");
        builder.blockTag("#flower, #orange").isFor("biomesoplenty:orange_cosmos, biomesoplenty:burning_blossom");
        builder.blockTag("#flower, #light_blue").isFor("biomesoplenty:blue_hydrangea");
        builder.blockTag("#flower, #purple").isFor("biomesoplenty:violet");
        builder.blockTag("#flower, #magenta").isFor("biomesoplenty:lavender, biomesoplenty:wildflower");
        builder.blockTag("#flower, #brown").isFor("biomesoplenty:wilted_lily, biomesoplenty:cattail");

        builder.blockTag("#bush").isFor("biomesoplenty:bush");

        builder.blockTag("#mushroom").isFor("biomesoplenty:toadstool, biomesoplenty:glowshroom");
        builder.blockTag("#mushroom").isFor("biomesoplenty:glowshroom_block");
        builder.blockTag("#grass").isFor("biomesoplenty:huge_clover_petal, biomesoplenty:sea_oats, biomesoplenty:reed");
        builder.blockTag("#seagrass").isFor("biomesoplenty:watergrass");
        builder.blockTag("#vine").isFor("biomesoplenty:willow_vine");

        builder.blockTag("#log").isFor("biomesoplenty:bramble");

        builder.blockTag("#mud").isFor("biomesoplenty:mud");
        builder.blockTag("#rock").isFor("biomesoplenty:crag_rock");

        builder.blockTag("#sand,#terrain,#ground").isFor([
            "biomesoplenty:white_sand",
            "biomesoplenty:black_sand",
            "biomesoplenty:orange_sand"]);

        builder.blockTag("#wooden").isFor([
            "biomesoplenty:cherry_* !#natural",
            "biomesoplenty:dead_* !#natural",
            "biomesoplenty:fir_* !#natural",
            "biomesoplenty:jacarandra_* !#natural",
            "biomesoplenty:mahogany_* !#natural",
            "biomesoplenty:hellbark_* !#natural",
            "biomesoplenty:palm_* !#natural",
            "biomesoplenty:redwood_* !#natural",
            "biomesoplenty:umbran_* !#natural",
            "biomesoplenty:willow_* !#natural",
            "biomesoplenty:stripped_*_log",
            "biomesoplenty:stripped_*_wood",
        ]).artificial();

        builder.blockTag("#magic").isFor(
            "biomesoplenty:magic_* !#natural").artificial();

        builder.blockTag("#stone").isFor([
            "biomesoplenty:black_sandstone_* !#natural",
            "biomesoplenty:orange_sandstone_* !#natural",
            "biomesoplenty:white_sandstone_* !#natural",
            "biomesoplenty:smooth_black_sandstone_* !#natural",
            "biomesoplenty:smooth_orange_sandstone_* !#natural",
            "biomesoplenty:smooth_white_sandstone_* !#natural"
        ]).artificial();

        // Older versions

        builder.blockTag("#vine").isFor("BiomesOPlenty:treeMoss");
        builder.blockTag("#grass").isFor("BiomesOPlenty:longGrass");
        builder.blockTag("#sand").isFor("BiomesOPlenty:hardSand");
        builder.blockTag("#dirt").isFor("BiomesOPlenty:hardDirt");
    }

}